const baseApiPath = getURL();
function GenerateURL(e) {
	let inputSiteUrl = $("#inputSiteUrl").val();
	let inputTitle = $("#inputTitle").val();
	let inputSiteName = $("#inputSiteName").val();
	let imageUrlBox = $("#imageUrlBox").val();
	let selectType = $("#selectType").val();
	let inputDescription = $("#inputDescription").val();

	let url = new URL(baseApiPath);
	url.searchParams.append(Base64.encodeURI("reqId"), Base64.encodeURI(randStr(5)));

	if (!$("#inputOpenGraph").is(":checked")) {
		url.searchParams.append(Base64.encodeURI("url"), encodeURIComponent(inputSiteUrl));
		DisplayGeneratedUrl(url);
		return;
	} else {
		if (inputTitle) {
			url.searchParams.append(Base64.encodeURI("og_title"), Base64.encodeURI(inputTitle));
			// redirectUrl += `&og_title=${encodeURIComponent(inputTitle)}`
		}
		if (inputSiteName) {
			url.searchParams.append(Base64.encodeURI("og_site_name"), Base64.encodeURI(inputSiteName));
			// redirectUrl += `&og_site_name=${encodeURIComponent(imageUrlBox)}`
		}
		if (inputDescription) {
			url.searchParams.append(Base64.encodeURI("og_description"), Base64.encodeURI(inputDescription));
			// redirectUrl += `&og_description=${encodeURIComponent(inputDescription)}`
		}
		if (selectType) {
			url.searchParams.append(Base64.encodeURI("og_type"), Base64.encodeURI(selectType));
			// redirectUrl += `&og_type=${encodeURIComponent(selectType)}`
		}
		if (imageUrlBox) {
			url.searchParams.append(Base64.encodeURI("og_image"), encodeURIComponent(imageUrlBox));
			// redirectUrl += `&og_img=${encodeURIComponent(imageUrlBox)}`
		}
		url.searchParams.append(Base64.encodeURI("url"), encodeURIComponent(inputSiteUrl));
		DisplayGeneratedUrl(url);
	}
}

function DisplayGeneratedUrl(url) {
	$("div#generated_url").text(url);
	let base_url = new URL(url);
	let dec_url = new URL(baseApiPath);
	base_url.searchParams.forEach((value, key) => {
		let dec_value;
		let dec_key;
		try {
			dec_value = Base64.atob(value);
			dec_key = Base64.atob(key);
		} catch (error) {
		} finally {
			if (key == "url" || dec_key == "url" || dec_key == "og_img") {
				dec_url.searchParams.append(key, decodeURIComponent(value));
			} else {
				dec_url.searchParams.append(dec_key, dec_value);
			}
		}
	});
	$("div#generated_url_dec").text(decodeURIComponent(dec_url));
}
var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
function randStr(max) {
	return Array.from({ length: max }, pickRandom).join("");
}
function pickRandom() {
	return possible[Math.floor(Math.random() * possible.length)];
}

$(document).ready(function () {
	$(".form-control").on("input", function (e) {
		GenerateURL(e);
	});
});
function removeTrailingSlash(str) {
	return str.replace(/\/+$/, '');
  }
function getURL() {
	let noslash = removeTrailingSlash(window.location.href);
	return noslash.slice(0, noslash.lastIndexOf("/")) + "/f79d601e26a782fd149b3ffb098aae9f";
}
